#include <pads.h>

void Remote::checkproto(int p)		{ if( get()!=p ) err(); }
void Remote::proto(int p)		{ put( p ); }

long Remote::rcvlong()			{ return (long)  shiftin( P_LONG  ); }
short Remote::rcvshort()		{ return (short) shiftin( P_SHORT ); }
unsigned char Remote::rcvuchar() { return (unsigned char) shiftin(P_UCHAR); }

void Remote::sendlong(long  x)		{ shiftout( P_LONG, x );	 }
void Remote::sendshort(short x)		{ shiftout( P_SHORT, (long) x ); }
void Remote::senduchar(unsigned char x)	{ shiftout( P_UCHAR, (long) x ); }

void Remote::pktstart(char c)		{ put(c);			}
void Remote::pktflush()			{ writesize = 0; pktend(); 	}

void Remote::put(char c)
{
	writebuffer[pktsize++] = c;
	if (pktsize == sizeof(writebuffer))
		pktflush();
}

void Remote::sendobj(PadRcv *o)
{
	sendlong((long)o);
}

PadRcv *Remote::rcvobj()
{
	PadRcv *obj = (PadRcv*)rcvlong();
	short oid = rcvshort();
	if (obj && obj->oid != oid)
		obj = 0;
	return obj;
}

void Remote::err(char *e)
{
	if( !e ) e = "Pads library: protocol error";
	PadsError(e);
}

Remote::Remote(int opened)
{
	fd = opened;
	pktsize = writesize = 0;
}

Remote::Remote(char *dev)
{
	fd = open(dev, 2);
	pktsize = writesize = 0;
}

void Remote::share()
{
	trace( "%d.share()", this, );
}	

long Remote::shiftin(register int bytes)
{
	register long shifter = 0;

	checkproto( bytes );
	while( bytes-- ) shifter = (shifter<<8) + (get()&0xFF);
	return shifter;
}

void Remote::shiftout( register bytes, register long shifter )
{
	proto( bytes );
	do { put( (char)(shifter>>( (--bytes)*8 )) ); } while( bytes );
}

long BytesToTerm;
void Remote::pktend()
{
	if (pktsize > writesize) {
		if (write(fd, (char*)writebuffer, pktsize) != pktsize)
			abort();
		BytesToTerm += pktsize;
		pktsize = 0;
		writesize = sizeof(writebuffer);
	}
}

char *Remote::rcvstring( char *s0 )
{
	register char *s = s0;
	register unsigned char len;

	checkproto( P_STRING );
	len = rcvuchar();
	if( !s0 ) s = s0 = new char [len+1];
	while( len-->0 ) *s++ = get();
	*s = '\0';
	return s0;
}

void Remote::sendstring(register char *s)
{
	int len;

	proto( P_STRING );
	len =  strlen(s);
	if( len > 255 ) len = 255;
	senduchar( len );
	while( len-- ) put(*s++); 
}

long BytesFromTerm;
int Remote::get()
{
	char c;
	if (pktsize) {
		err();
		return 0;
	}
	while (read(fd, &c, 1) != 1) {
		if (errno == EINTR)
			continue;
		err();
	}
	++BytesFromTerm;
	return c;
}
